/* _______________________ *\
	/ 											\  
 |       RadLib v1.0			 | 
 |   Radnen's RPG library  | 
 | 	  Radnen, Oct. 2008		 | 
 |_________________________| 
 |												 | 
 |		Main Include File		 | 
	\_______________________/  
\*												 */

if (GetVersion() < 1.4) Abort(" - Sorry, RadLib needs a Sphere version of 1.4 or higher \
to work correctly.\n\n - You are using version: " + GetVersion() + "\n\n - Head to \
www.spheredev.org/wiki/latest to get the latest version.\n");

GetSystemFont().drawText(0, 0, "Loading RadLib v1.0... Please Wait...");
FlipScreen();

// Library fading constants //
const FADE_IN = 1, FADE_OUT = 2, FADE_STOP = 0;
const LINEAR = 0, LOGARITHMETIC = 1;

// Library screen constants //
const SW = GetScreenWidth();
const SH = GetScreenHeight();

// Library TextBox constants //
const TOP = 0, BOTTOM = 1;

// Library Movement Constants //
const NORTH   = COMMAND_MOVE_NORTH;
const SOUTH   = COMMAND_MOVE_SOUTH;
const EAST    = COMMAND_MOVE_EAST;
const WEST    = COMMAND_MOVE_WEST;
const WAIT    = COMMAND_WAIT;
const ANIMATE = COMMAND_ANIMATE;

// Internal RadLib Global Object //
RadLib = {useCursor: false, nullImage: LoadImage("RadLib/Null.png")};

function Alert(text) {
	while(AreKeysLeft()) GetKey();
	while(!IsAnyKeyPressed()) {
		GetSystemFont().drawText(0, 0, text);
		FlipScreen();
	}
}

// Include the basic color objects //
RequireScript("RadLib/Rad_Colors.js");

// Include the error/debug console //
RequireScript("RadLib/Rad_Bug.js");

// Include Rad_Extend which extends JS objects //
RequireScript("RadLib/Rad_Extend.js");
RequireScript("RadLib/Other/json2.js");

// Include the system controls //
// Controls are used to create custom menus //
RequireScript("RadLib/Controls/Rad_Style.js");
RequireScript("RadLib/Controls/Rad_Panel.js");
RequireScript("RadLib/Controls/Rad_ListBox.js");
RequireScript("RadLib/Controls/Rad_TabList.js");
RequireScript("RadLib/Controls/Rad_Itemset.js");
RequireScript("RadLib/Controls/Rad_Slider.js");
RequireScript("RadLib/Controls/Rad_StatusBar.js");
RequireScript("RadLib/Controls/Rad_Input.js");
RequireScript("RadLib/Controls/Rad_Timer.js");

// Add game related stuff //
RequireScript("RadLib/Rad_Mouse.js");
RequireScript("RadLib/Rad_Menu.js");
RequireScript("RadLib/Rad_Intro.js");
RequireScript("RadLib/Rad_Text.js");
RequireScript("RadLib/Rad_DynaImage.js");
RequireScript("RadLib/Rad_Move.js");
RequireScript("RadLib/Rad_Animate.js");

// Include Game Engine related stuff //
RequireScript("RadLib/Rad_Platformer.js");

// Include Battle Related stuff //
RequireScript("RadLib/Rad_Stat.js");

// Include storylining elements //
RequireScript("RadLib/Rad_Cam.js");
RequireScript("RadLib/Rad_Sound.js");
RequireScript("RadLib/Rad_Fade.js");

// Include pathfinding algorithm //
RequireScript("RadLib/Rad_Path.js");

// Finally RadLib must hijack a constant updater such as FlipScreen //
var _FlipScreen = FlipScreen;
FlipScreen = function()
{
	if (RadLib.useCursor) Cursor.draw(), Cursor.handleUnPress();
	CheckKeyStates();
	_FlipScreen();
}

// Introduce the library and Sphere //    
// Completely optional for end-user //  
function PlayRadLibIntro(sphere)
{	
	var surf;
	var RadLibBG = new DynaImage("RadLib/RadLibBG.png");
	surf = RadLibBG.img.createSurface();
	RadLibBG.img = surf.rescale(SW, SH).createImage();
	var RadLibImage = new DynaImage("RadLib/RadLib.png");
	surf = RadLibImage.img.createSurface();
	RadLibImage.img = surf.rescale(SW, SH).createImage();
	
	if (sphere) {
		var SphereImage = new DynaImage("RadLib/Sphere.png")
		surf = SphereImage.img.createSurface();
		SphereImage.img = surf.rescale(SW, SH).createImage();
	}
	
	var intro = new IntroBlock();
	intro.preRender = function() {
		RadLibBG.blit(0, 0);
	}
	intro.addAction(function() {
		RadLibImage.setFade(FADE_IN, 1500);
	});
	intro.addAction(function() {
		RadLibImage.update(2000);
	}, 3000);
	intro.addAction(function() {
		RadLibImage.setFade(FADE_OUT, 1500);
	});
	intro.addAction(function() {
		RadLibImage.update(2000);		
	}, 1000);
	if (sphere) {
		intro.addAction(function() {
			SphereImage.setFade(FADE_IN, 1500);
		});
		intro.addAction(function() {
			SphereImage.update(2000);
		}, 3000);
		intro.addAction(function() {
			SphereImage.setFade(FADE_OUT, 1500);
		});
		intro.addAction(function() {
			SphereImage.update(2000);		
		}, 1000);
	}
	intro.play();
}